
function [Yproj] = LF_Proj(Y,q,I_trend)
    % Process the Y data .. where Y is T x n
    % q ... number of periodic regressors 
    % i_trend = 0: include mean (level), 1: include level and linear trend
    % 
    % In this function, the period components are the eigenvectors of the demeaned or detrended RW covariance matrix
    %
    % 
    
    % Some constants
    T = size(Y,1);
    n = size(Y,2);

    % Step 1: Construct deterministic components 
    WT = [ones(T,1)];
    q1 = q;
    if I_trend == 1
        trend = (1:1:T)';
        WT = [WT trend];
        q1 = q - 1;
    end
    
    
    % Step 2: Compute periodic terms -- eigenvectors of demeaned or detrended covariance matrix
    cov_rw = rw_cov(T);
    M = eye(T) - WT*inv(WT'*WT)*WT';
    cov_dt = M*cov_rw*M';
    [evec_mat,eval]=eig(cov_dt,'vector');
    A = evec_mat(:,1:q1);
    W = [WT A];
    B = W\Y;
    Yproj = W*B;
    
end
    